// PROGRAMA CARTERO - CIIC 2001
// Se crea la matriz de caminos mnimos utilizando FLOYD y luego se halla
// el camino mnimo entre Ci - Aj - Cf para todos los posibles 1<=j<=m
// Ci : Esquina de la Oficina Postal Inicial.
// Aj : Esquina j donde se puede almorzar.
// Cf : Esquina de la Oficina Postal Final.
// m  : Cantidad de lugares donde se puede almozar.

//Librerias
#include <stdio.h>
#include <conio.h>
#include <limits.h>

//Prototipos
void leer();
void floyd();
void minimo();
void camino (unsigned short ini, unsigned short fin);

//Definiciones
#define MAX 251        // Nmero mximo de extremos de calles

//Variables
struct tcalle
{
    unsigned short perros;      // Numero de perros en calle mapa[i][j]
    unsigned short quien;       // Esquina intermedia entre minimo de mapa[i][j]
} mapa[MAX][MAX];               // Estructura que almacena el mapa de la ciudad
int nmapa=0, ncalles, nalmuerzo, min=INT_MAX;
unsigned short almuerzo[MAX], ini, fin, pclave;
FILE *entrada, *salida;

// Funcion principal
int main()
{
    leer();                             // Leer datos desde archivo
    floyd();                            // Aplicar algoritmo de FLOYD
    minimo();                           // Hallar minimo Ci - Aj - Cf
    fprintf (salida, "%d ", ini);
    camino (ini, pclave);               // Imprime camino Ci - Aj
    camino (pclave, fin);               // Imprime camino Aj - Cf
    fclose (salida);
    return 0;
}

// Reconstruye recursivamente camino solucion
void camino (unsigned short ini, unsigned short fin)
{
     if (mapa[ini][fin].quien!=USHRT_MAX)       //USHRT_MAX significa hay camino directo
     {
        camino (ini, mapa[ini][fin].quien);
        camino (mapa[ini][fin].quien, fin);
     }
     else
        if (fin==pclave)
           fprintf (salida, "%d* ", fin);
        else
           fprintf (salida, "%d ", fin);
}

// Halla camino mnimo entre los caminos Ci - Aj - Cf para 1<=j<=m
void minimo()
{
     int i;

     for (i=0;i<nalmuerzo;i++)
     {
         if ((mapa[ini][almuerzo[i]].perros+mapa[almuerzo[i]][fin].perros)<min)
         {
            pclave=almuerzo[i];
            min=mapa[ini][almuerzo[i]].perros+mapa[almuerzo[i]][fin].perros;
         }
     }
     salida=fopen("cartero.sal","wt");
     fprintf (salida, "%d\n", min);
}

// Funcion que lee la informacin desde archivo y lo guarda en la matriz de adyacencia
void leer()
{
    int i, j, aux1, aux2, aux3;

    clrscr();
    for (i=0;i<MAX;i++)
        for (j=0;j<MAX;j++)
        {
            mapa[i][j].perros=USHRT_MAX;
            mapa[i][j].quien=USHRT_MAX;
            if (i==j)
               mapa[i][i].perros=0;
        }
    entrada=fopen("cartero.ent","rt");
    fscanf (entrada, "%d", &ncalles);
    for (i=1;i<=ncalles;i++)
    {
        fscanf (entrada, "%d%d%d", &aux1, &aux2, &aux3);
        mapa[aux1][aux2].perros=aux3;
        mapa[aux2][aux1].perros=aux3;
        if (nmapa<aux1)
           nmapa=aux1;
        if (nmapa<aux2)
           nmapa=aux2;
    }
    fscanf(entrada, "%d", &ini);
    fscanf(entrada, "%d", &fin);
    fscanf(entrada, "%d", &nalmuerzo);
    for (i=1;i<=nalmuerzo;i++)
        fscanf (entrada, "%d", &almuerzo[i-1]);
    fclose(entrada);
}

// Algoritmo de FLOYD
void floyd()
{
     int i, j ,k;

     for (k=0;k<=nmapa;k++)
         for (i=0;i<=nmapa;i++)
             for (j=0;j<=nmapa;j++)
                 if ((mapa[i][k].perros!=USHRT_MAX)&&(mapa[k][j].perros!=USHRT_MAX))
                    if (mapa[i][k].perros+mapa[k][j].perros<mapa[i][j].perros)
                    {
                       mapa[i][j].perros=mapa[i][k].perros+mapa[k][j].perros;
                       mapa[i][j].quien=k;
                    }
}



