// PROGRAMA ENCAJAR - CIIC 2001
// Se crea una estructura optima que nos evita hacer multiples consultas
// de un rango de celdas adyacentes, almacenando el numero de filas y columnas
// libres.

// Librerias estandar
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <time.h>

#define MAX 200   //Dimension maxima para el tablero

//Prototipos
void lectura();
void proceso();
void rota (unsigned char origen, unsigned char destino);
void llenar();
void llenarh();

//Estructura de datos que almacena el tablero y celdas libres
struct tgrilla
{
       unsigned char marca, f, c;
} tablero[MAX+1][MAX+1];
struct ttamano
{
       unsigned char pff, pfc, tf, pcf, pcc, tc;
       //pff: Coordenada en fila area horizontal de mayor tamao
       //pfc: Coordenada en columna area horizontal de mayor tamao
       //tf : Tamao de area horizontal de mayor tamao
       //pcf: Coordenada en fila area vertical de mayor tamao
       //pcc: Coordenada en columna area vertical de mayor tamao
       //tc : Tamao de area vertical de mayor tamao
} tamano[4];
unsigned char herramienta[4][MAX/2][MAX/2];  // Almacena herramienta
int nfil, ncol, nfilh, ncolh;
FILE *entrada, *salida;                      // Archivos de I/O

//Funcion principal
void main()
{
     clock();
     lectura();
     llenar();
     proceso();
}

//Lee del archivo de entrada la configuracion del tablero y de la herramienta
void lectura()
{
     int i, j;

     clrscr();
     memset (tablero, 1, sizeof(tablero));
     memset (herramienta, 0, sizeof(herramienta));
     entrada=fopen("encajar.ent","rt");
     fscanf (entrada, "%d%d", &nfil, &ncol);
     fgetc(entrada);
     for (i=1;i<=nfil;i++)
     {
         for (j=1;j<=ncol;j++)
         {
             tablero[i][j].marca=fgetc(entrada);
             if (tablero[i][j].marca=='.')
                tablero[i][j].marca=0;
             else
                tablero[i][j].marca=1;
         }
         fgetc(entrada);
     }
     fscanf (entrada, "%d%d", &nfilh, &ncolh);
     fgetc(entrada);
     for (i=0;i<nfilh;i++)
     {
         for (j=0;j<ncolh;j++)
         {
             herramienta[0][i][j]=fgetc(entrada);
             if (herramienta[0][i][j]=='.')
                herramienta[0][i][j]=0;
             else
                herramienta[0][i][j]=1;
         }
         fgetc(entrada);
     }
     fclose(entrada);
}

// Llena los campos tablero[i][j].f y tablero[i][j].c que corresponden
// al nmero de celdas libres horizontal y verticalmente a partir de [i][j]
void llenar()
{
     int i, j, k, n;

     //Llenar Filas
     for (i=1;i<=nfil;i++)
         for (j=ncol;j>=1;j--)
         {
             n=0;
             while (!(tablero[i][j-n].marca))   //Reviza zonas horizontales
             {
                   tablero[i][j-n].f=n+1;
                   n++;
             }
             if (!n)
                tablero[i][j].f=0;
             else
             j-=n-1;                            //Salto a siguiente area
         }
     //Llenar Columnas
     for (i=1;i<=ncol;i++)
         for (j=nfil;j>=1;j--)
         {
             n=0;
             while (!(tablero[j-n][i].marca))   //Reviza zonas verticales
             {
                   tablero[j-n][i].c=n+1;
                   n++;
             }
             if (!n)
                tablero[j][i].c=0;
             else
             j-=n-1;                            //Salto a siguiente area
         }
}

// Encuentra y almacenas areas clave, horizintal y verticalmente,
// para cada rotacin de la herramienta
void llenarh()
{
     int i, j, m, max, fmax, cmax, n, nfilas, ncolumnas;

     for (m=0;m<4;m++)
     {
         //llenar fila;
         if ((m % 2)==0)
         {
            nfilas=nfilh;
            ncolumnas=ncolh;
         }
         else
         {
            nfilas=ncolh;
            ncolumnas=nfilh;
         }
         max=0;
         for (i=0;i<nfilas;i++)
         {
             for (j=0;j<ncolumnas;j++)
             {
                 n=0;
                 while (herramienta[m][i][j+n])
                       n++;
                 if (n>max)
                 {
                    max=n;
                    fmax=i;
                    cmax=j;
                 }
                 if (n)
                    j+=n-1;
             }
         }
         tamano[m].tf=max;
         tamano[m].pff=fmax;
         tamano[m].pfc=cmax;
         //Llenar Columnas
         max=0;
         for (i=0;i<ncolumnas;i++)
         {
             for (j=0;j<nfilas;j++)
             {
                 n=0;
                 while (herramienta[m][j+n][i])
                       n++;
                 if (n>max)
                 {
                    max=n;
                    fmax=j;
                    cmax=i;
                 }
                 if (n)
                    j+=n-1;
             }
         }
         tamano[m].tc=max;
         tamano[m].pcf=fmax;
         tamano[m].pcc=cmax;
     }
}

// Realiza las rotaciones de la herramienta, y luego hace la bsqueda de la
// posicin adecuada para la herramienta (en cualquiera de sus rotaciones)
// Descarta anticipadamente posiciones invalidas.
void proceso()
{
     int i, j, k, l, m, sirve, nfilas, ncolumnas;

     rota (0, 1);
     rota (1, 2);
     rota (2, 3);
     llenarh();

     salida=fopen("encajar.sal","wt");
     for (i=1;i<=nfil;i++)
         for (j=1;j<=ncol;j++)
             for (m=0;m<4;m++)
             {
                 if ((tablero[i+tamano[m].pff][j+tamano[m].pfc].f<tamano[m].tf)||(tablero[i+tamano[m].pcf][j+tamano[m].pcc].c<tamano[m].tc))
                    continue;   //No es posible encajar, saltar a siguiente rotacion
                 sirve=1;
                 if ((m % 2)==0)
                 {
                    nfilas=nfilh;
                    ncolumnas=ncolh;
                 }
                 else
                 {
                    nfilas=ncolh;
                    ncolumnas=nfilh;
                 }
                 if (((i+nfilas-1)>nfil)||((j+ncolumnas-1)>ncol))
                    continue;
                 for (k=0;((k<nfilas)&&sirve);k++)
                     for (l=0;l<ncolumnas;l++)
                         if ((tablero[i+k][j+l].marca & herramienta[m][k][l]))
                         {
                            sirve=0;
                            break;
                         }
                 if (sirve)
                 {
                    fprintf (salida, "%d %d\n%d",i, j, m);
                    fclose (salida);
                    printf ("tiempo : %0.2f\n",(float)clock()/CLOCKS_PER_SEC);
                    exit (0);
                 }
             }
     fprintf (salida, "No hay solucion");
     fclose (salida);
     printf ("tiempo : %0.2f\n",(float)clock()/CLOCKS_PER_SEC);
}

// Funcin que construye la rotacion de la figura hacia la derecha
void rota (unsigned char origen, unsigned char destino)
{
     int i, j, nfilas, ncolumnas;

     if ((origen % 2)==0)
     {
        nfilas=nfilh;
        ncolumnas=ncolh;
     }
     else
     {
        nfilas=ncolh;
        ncolumnas=nfilh;
     }

     for (i=0;i<nfilas;i++)
         for (j=0;j<ncolumnas;j++)
             herramienta[destino][j][nfilas-i-1]=herramienta[origen][i][j];
}
