/* III CIIC
   Solucin
   Problema de Cajero
   Duvier Zuluaga Mora

   Versin Final 
*/

#include <stdio.h>
#include <stdlib.h>

// Lmites del nmero de cajeros y el nmero de clientes
#define MAXCAJ 10
#define MAXCLI 100

// Archivos de entrada y salida
#define ARCH_ENTRADA "fila.ent"
#define ARCH_SALIDA "fila.sal"

typedef struct {
    int hLleg;    // Hora de llegada del cliente
    int dem;      // Demora en la fila
} TCliente;

int ncajeros;
int nclientes;

// Arreglo de los clientes
TCliente clientes[MAXCLI];

// Arreglo de los cajeros (Guarda el instante en que se desocupa un cajero)
int cajeros[MAXCAJ];

// Variables de Salida
int maxLong;  // Longitud mxima de la fila
int maxDem;   // Demora mxima
int demorados[MAXCLI];  // Arreglo de las personas que tuvieron la
                        // mayor demora
int ndem;               // Nmero de personas con esa demora

void LeerParametros()
{
   FILE* entrada;
   int i;

   entrada = fopen(ARCH_ENTRADA,"rt");

   fscanf(entrada,"%d", &ncajeros);
   fscanf(entrada,"%d", &nclientes);

   for (i=0; i<nclientes; i++)
       {
          fscanf(entrada,"%d", &(clientes[i].hLleg) );
          fscanf(entrada,"%d", &(clientes[i].dem) );
       }

   fclose(entrada);
}

void Simular()
{
    int persona;
    int i;
    int caj;     // Cajero elegido para atender a la persona
    int mint;    // Tiempo mnimo en que se desocupa un cajero para
                 // atender a la persona
    int dem;     // Demora de la persona en la fila
    int ini;     // Hora de inicio de atencin
    int lon;     // Longitud de la fila cuando llega la persona

    // Guarda los momentos en que se comienza a atender cada persona
    // para saber la longitud mxima de la fila
    int fila[MAXCLI];
    int iniFila;   // Guarda quien es la cabeza de la fila cuando llega una
                   // persona

    // Inicializar todos los cajeros como libres en el tiempo 0
    for (i=0; i<ncajeros; i++)
        cajeros[i] = 0;

    // Procesar a la primera persona ocupando el primer cajero
    cajeros[0] = clientes[0].hLleg+clientes[0].dem;

    // La primera persona se atiende en el momento que llega
    // y es la que encabeza la fila
    // Marcar la mxima demora y la mxima longitud de fila
    // Por el momento es tambin la mxima demora
    maxDem = 0;
    demorados[0] = 0;
    ndem = 1;
    maxLong = 0;
    fila[0] = clientes[0].hLleg;
    iniFila = 0;

    // Procesar cada persona siguiente
    for (persona=1; persona<nclientes; persona++)
        {
            // Revisar cuantas personas hay en la fila cuando llega esta
            // persona
            // Revisamos en la fila cuales de las personas anteriores aun
            // no han comenzado a ser atendidas. Es decir, las que tengan el
            // tiempo de inicio atencin mayor a la hora de llegada de esta
            // persona
            // Comenzamos a revisar desde iniFila, porque los que estn antes
            // ya han sido atendidos

            while (iniFila<persona && fila[iniFila]<=clientes[persona].hLleg)
                  {
                   iniFila++;   // La persona en iniFila ya comenz a ser
                                // atendida cuando persona llega
                  }
            // La longitud de la fila. Es la persona actual, menos el lugar
            // donde inician las personas que esperan atencin ms mi lugar
            // en la fila
            lon = persona - iniFila + 1;



            // Buscar el cajero que se desocupe ms pronto para atender a
            // esta persona
            mint = 100000;
            for (i=0; i<ncajeros;i++)
                {
                 if (cajeros[i]<mint)    // Si este cajero se libera ms pronto
                    {
                     mint = cajeros[i];
                     caj = i;
                    }
                }

            // Medir el tiempo que se demora la persona en la fila
            // Si el cajero fue desocupado antes de la llegada de la persona
            // su demora es cero, sino es el tiempo en que se desocupa el
            // cajero menos el tiempo en que la persona llega
            // Marcamos adems la hora en la que se inicia la atencin
            if (cajeros[caj]<clientes[persona].hLleg)
               {
                dem = 0;
                ini = clientes[persona].hLleg;
               }
            else
                {
                 dem = cajeros[caj] - clientes[persona].hLleg;
                 ini = cajeros[caj];
                }

            // Ver si esta persona es la que tiene mxima demora
            // o si est en el grupo de las que tienen mxima demora
            if (dem > maxDem)
               {
                // La demora de esta persona es la mxima
                maxDem = dem;    // Actualizar la demora
                // Reiniciar el arreglo de los ms demorados
                demorados[0] = persona;
                ndem = 1;
               }
            else
                {
                 if (dem == maxDem)
                    {
                     // Esta persona est en el grupo de las que tienen
                     // demora mxima, incluirla
                     demorados[ndem] = persona;
                     ndem++;
                    }
                }

            // Marcar el tiempo en que se desocupa el cajero
            // es la hora de inicio de atencin ms la demora

            cajeros[caj] = ini+clientes[persona].dem;

            // Marcar el momento en que se empieza a atender a esta persona
            // que es cuando sale de la fila
            fila[persona] = ini;

            // Si el momento en que comienzan a atenderme es igual a mi
            // hora de llegada entonces no habr fila

            if (ini == clientes[persona].hLleg)
               lon = 0;

            // Ver si la longitud de la fila es mxima para actualizarla
            if (lon>maxLong)
               maxLong = lon;
        }
}

void ImprimirSalida()
{
   FILE* salida;
   int i;

   salida = fopen(ARCH_SALIDA, "wt");

   fprintf(salida, "%d ", maxLong);   // Mxima longitud
   fprintf(salida, "%d ", maxDem);     // Mxima demora
   fprintf(salida, "%d\n", ndem);       // Nmero de personas con mxima
                                        // demora

   // Imprimir las personas que tuvieron mxima demora, una por lnea
   for (i=0; i<ndem; i++)
       {
        fprintf(salida, "%d\n", demorados[i]+1);
        // Demorados[i]+1 para convertir ndices base 0 a ndices base 1
       }

   fclose(salida);
}

void main()
{
   LeerParametros();
   Simular();
   ImprimirSalida();
}
