// PROGRAMA LATIN - CIIC 2001
// Se construye una red de flujo con la informacin de entrada y luego se
// ejecuta un algoritmo de flujo maximo en redes para solucionar el problema.
// El algoritmo usado es el de LIFT-TO-FRONT que presenta un O(V^3)

// Librerias estandar
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <time.h>
#include <limits.h>

// Valores maximos
#define MAXC 100                // Numero maximo de ciudades
#define MAXA 100                // Numero maximo de almacenes
#define MAX  MAXC+MAXA+2

//Archivos
FILE *entrada, *salida;

// Prototipos
void leer();
void flujo();
void inicializar();
void descargar(short int u);
short int min(short int a, short int b);
void inyectar(short int u, short int v);
void ascender(short int u);
void imprimir();

// Matriz que almacena la red G={V,E}
struct tred
{
       short int f, c;       //Flujo(f), Capacidad(c)
} red[MAX][MAX];
short int e[MAX], cf;        //Exceso de flujo(e), capacidad residual(cf)
short int h[MAX], df;        //Nivel(h), Flujo a ser inyectado(df)
short int L[MAX];            //Lista de vertices(L)
short int n, m, k;           //Tamaos
short int i, j;              //Variables adicionales
short int N[MAX][MAX];       //Lista de adyacentes(N)
short int pN[MAX];           //Posicion actual en lista de adyacentes

// Funcion principal
void main()
{
     leer();
     flujo();
     imprimir();
     exit(0);
}

//Inicializar preflujo
void inicializar()
{
     memset (h, 0, sizeof(h));          //Inicializar niveles a 0
     memset (e, 0, sizeof(e));          //Inicializar exceso de flujo a 0
     //Incializacion de flujo ya fue hecha en la lectura
     h[0]=m+n+1;                        //Inicializar fuente con el max nivel
     for (i=1;i<=n;i++)
     {
         red[0][i].f=red[0][i].c;
         red[i][0].f=-red[0][i].c;
         e[i]=red[0][i].c;
     }
     //Construir lista de adyacentes
     memset (N, 0, sizeof(N));
     memset (pN, 0, sizeof(pN));
     for (i=0;i<=n+m+1;i++)
     {
         for (j=0;j<=n+m+1;j++)
         {
             if ((red[i][j].c>0)||(red[j][i].c>0))      //Hay arco entre i-j?
             {
                N[i][pN[i]]=j;
                pN[i]++;
             }
         }
     }
     memset (pN, 0, sizeof(pN));
}

//Menor entre a y b
short int min(short int a, short int b)
{
      return a<b?a:b;
}

//Inyectar nuevo flujo entre u y v
//cuando Cf[u,v]>0 y h[u]=h[v]+1 (Ya comprobado en descargar)
void inyectar(short int u, short int v)
{
     df=min(e[u], cf);
     red[u][v].f+=df;
     red[v][u].f=-red[u][v].f;
     e[u]-=df;
     e[v]+=df;
}

//Aumenta de nivel el vrtice u
//cuando u esta sobrecargado (e[u]>0) y para todos los v E V, (u, v) e Ef (Red Residual)
//se tiene que h[u]<=h[v] (Ya comprobado en descargar)
void ascender(short int u)
{
     short int cf, min=SHRT_MAX, i;

     for (i=0;i<=n+m+1;i++)
     {
         cf=red[u][i].c-red[u][i].f;
         if (cf>0)                     //(u,i) E Ef
            if (h[i]<min)
               min=h[i];
     }
     h[u]=min+1;
}

//Descarga vrtice u
void descargar(short int u)
{
     short int v, actual;               // Nodo actual, Posicion en N

     while (e[u]>0)                     // Hay exceso de flujo en u?
     {
           actual=N[u][pN[u]];
           v=actual;
           if ((v==0)&&(pN[u]>0))      // Se acabaron los vecinos?
           {
              ascender(u);              //Ascender u y actual=head[N]
              pN[u]=0;
              actual=N[u][pN[u]];
           }
           else
           {
              cf=red[u][v].c-red[u][v].f;       //calcular capacidad residual
              if ((cf>0)&&(h[u]==h[v]+1))       //Hay cf y estn a un nivel de distancia?
                 inyectar(u,v);
              else
                 pN[u]++;
           }
     }
}

//Algoritmo de flujo maximo en redes
void flujo()
{
     int u, nivelanterior, pl;

     inicializar();             //Inicializar preflujo
     memset (L, 0, sizeof(L));  //Generar lista de vertices
     for (i=1;i<=n+m;i++)
         L[i-1]=i;
     u=L[0];
     pl=0;
     while (u!=0)
     {
           nivelanterior=h[u];
           descargar(u);
           if (h[u]>nivelanterior)                      //Subio de nivel?
           {
              memmove (&L[1], &L[0], sizeof(L[0])*pl);  //Colocarlo al inicio de L
              L[0]=u;
              pl=0;
           }
           pl++;
           u=L[pl];
     }
}

//Funcion que lee los datos del archivo de entrada y construye la red de flujo
//con ellos. La red queda almacenada en red[i][j].c
void leer()
{
     int x, y, z;

     memset(red, 0, sizeof(red));
     entrada=fopen("latin.ent","rt");
     fscanf (entrada, "%d", &n);                     //Numero de almacenes
     for (i=1;i<=n;i++)                              //Leer Almacenes
         fscanf (entrada, "%d", &red[0][i].c);       //red[fuente][almacen]
     fscanf (entrada, "%d", &m);                     //Numero de ciudades
     for (i=1;i<=m;i++)                              //Leer ciudades
         fscanf (entrada, "%d", &red[n+i][n+m+1].c); //red[ciudades][sumidero]
     fscanf (entrada, "%d", &k);                     //Numero de camiones k
     for (i=1;i<=k;i++)
     {
         fscanf (entrada, "%d%d%d", &x,&y,&z);       //Leer camiones
         red[x][n+y].c=z;                            //red[almacen][ciudad]
     }
     fclose(entrada);
}

//Imprimir solucin con el formato exigido
void imprimir()
{
     int total;

     salida=fopen("latin.sal","wt");
     total=0;
     for (i=1;i<=n;i++)
         total+=red[0][i].f;
     fprintf (salida, "%d\n", total);                   //Imprime flujo total
     for (i=1;i<=n;i++)
         for (j=1;j<=m;j++)
             if (red[i][n+j].c>0)
                fprintf (salida, "%d ",red[i][n+j].f);  //Imprime flujo x camin
     fprintf (salida, "\n");
     for (i=1;i<=m;i++)
         fprintf (salida, "%d ",red[n+i][n+m+1].f);     //Imprime flujo x ciudad
     fclose(salida);
}

