/*
  CIIC 2002
  Problema Camino
  Solucin Borrando un vrtice y verificando
  si es posible llegar al otro extremo
  Duvier Zuluaga
*/

#include <stdio.h>
#include <string.h>


#define ARCH_ENT "CAMINO.ENT"
#define ARCH_SAL "CAMINO.SAL"

typedef struct TArco
{
 int destino;
 struct TArco* next;
} TArco;

// El grafo se va a representar por medio de una lista de adyacencia
TArco* grafo[10001];

void Inicializar()
{
 int i;

 // Inicializamos todos los arcos en NULL
 for (i=1; i<=10000; i++)
     grafo[i] = NULL;
}

void LiberarMemoria()
{
 int i;
 TArco* p, *q;

 for (i=1; i<=10000; i++)
 {
  p = grafo[i];
  while (p != NULL)
  {
   q = p;
   p = p->next;
   delete q;
  }
 }
}

void CargarDatos()
{
 int i, n;
 FILE* entrada;
 int x, y;
 TArco* p;

 entrada = fopen(ARCH_ENT, "rt");

 fscanf(entrada, "%d", &n);

 // Cargar cada calle en el grafo
 for (i=0; i<n; i++)
 {
  fscanf(entrada, "%d %d", &x, &y);
  // Crear la calle de x a y
  p = new TArco;
  p->destino = y;
  p->next = grafo[x];
  grafo[x] = p;
  // Ahora la calle de y a x
  p = new TArco;
  p->destino = x;
  p->next = grafo[y];
  grafo[y] = p;
 }

 fclose(entrada);
}

// Aqu guardamos el estado de los vrtices durante el recorrido de la
// bsqueda en profundidad, 0 si no han sido visitados y 1 si ya han
// sido visitados
unsigned char visitado[1001];

// Este indica cual es el vrtice que se ha borrado
int borrado;

// Esta bandera indica si se debe cortar la DFS porque ya llegamos al
// vrtice del trabajo y sabemos que el vrtice borrado no es indispensable
int cortar;

// Esta funcin realiza la bsqueda en profundidad a partir del vrtice
// recibido como parmetro
void DFS(int origen)
{
 TArco* p;

 visitado[origen] = 1;

 // Revisamos si este lugar es el trabajo para no seguir haciendo la bsqueda
 // en profundidad porque ya sabemos que el vrtice borrado no era indispensable
 if (origen == 1000)
 {
  cortar = 1;
  return;
 }

 p = grafo[origen];
 while (p != NULL)
 {
  // Revisar si por este arco llegamos a un lugar no visitado
  // para iniciar una nueva bsqueda en profundidad desde all
  // Y adems se debe tener en cuenta que no sea el vrtice que se ha
  // borrado
  if ( (!visitado[p->destino]) && (p->destino != borrado) )
     DFS(p->destino);

  // Revisamos si se logr la bandera de cortar para no continuar la
  // recursin
  if (cortar)
     return;

  // Avanzar al siguiente arco
  p = p->next;
 }
}

void Proceso()
{
 FILE* salida;

 salida = fopen(ARCH_SAL, "wt");
 // Probamos borrando cada vrtice y mirando si no es posible llegar
 // al trabajo
 for (borrado=2; borrado<1000; borrado++)
 {
  // Inicializar el estado de todos a no visitado
  memset(visitado, 0, 1001);
  // Y la bandera de cortar a falso
  cortar = 0;
  // Hacemos un Depth-First Search iniciando en el vrtice 1
  DFS(1);
  // Y ahora vemos: Si no fue posible llegar al vrtice 1000 indica que
  // este es uno de los vrtices por los cuales es necesario pasar
  if (!visitado[1000])
     fprintf(salida, "%d\n", borrado);
 }

 fclose(salida);
}

int main()
{
 Inicializar();
 CargarDatos();
 Proceso();
 LiberarMemoria();
 return 0;
}


