/* SOLUCION PROGRAMA ARCA DE NOE
   CIIC 2002
   PROGRAMACION DINAMICA
   RAUL ANDRES DUQUE
*/

#include <stdio.h>
#include <conio.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>

#define MAXFAM 8           // Numero maximo de familias
#define MAXANI 100001      // Numero maximo de animales en la lista
#define ARCENT "ARCA.ENT"  // Nombre de archivo de entrada
#define ARCSAL "ARCA.SAL"  // Nombre de archivo de salida


// Constantes del problema
const int rango[MAXFAM+1][2] = { {  0,    0},       //Rangos de Codigos para familia
                                 {  0, 1000},       //Familia No. 1
                                 {  0,   45},       //Familia No. 2
                                 { 46,  285},       //Familia No. 3
                                 {286,  780},       //Familia No. 4
                                 {770, 1000},       //Familia No. 5
                                 {100,  115},       //Familia No. 6
                                 {500,  545},       //Familia No. 7
                                 {850,  960} };     //Familia No. 8
const int tamano[MAXFAM+1] = {0, 10, 6, 8, 9, 8, 5, 6, 7}; //Tamao de codigo de cada familia
// Familia:                   -   1  2  3  4  5  6  7  8

// Variables Globales
int n;                          // Numero de animales
int tabla[MAXFAM+1][MAXANI+1];  // Tabla a llenar dinmicamente
//  tabla[i][j] : Mejor tamano de lista hasta el animal j terminando
//                en la familia i como activa
short int solucion[MAXFAM+1][MAXANI+1];  // Tabla para poder reconstruir solucion
FILE *entrada, *salida;         // Archivo de entrada y salida

// Funcion que inicializa la estructura y abre archivo de entrada
void inicializar()
{
     int i;

     clrscr();
     entrada=fopen (ARCENT, "rt");
     fscanf (entrada, "%d", &n);
     memset (tabla, 0, sizeof(tabla));
     memset (solucion, 0, sizeof(solucion));
     for (i=2;i<=MAXFAM;i++)             // Se marcan como invalidas familias
         tabla[i][0]=-1;                 // diferente a la 1 pues en esta se inicia
}

// Funcion que determina si animal esta en el rango de familia
int enrango (int animal, int familia)
{
    return ((animal>=rango[familia][0])&&(animal<=rango[familia][1]));
}

// Funcion que llena la tabla dinamica
void procesar()
{
     int i, j, k, animal, nmejor, mejor, imejor, total;

     for (i=1;i<=n;i++)                 // Por cada animal en la lista
     {
         fscanf (entrada, "%d", &animal);
         // Buscamos la familia con menor tamao de codigo para este animal
         // para ser usada como cambio por solo este animal.
         mejor=INT_MAX;
         for (k=1;k<=MAXFAM;k++)
             if (enrango(animal, k)&&(tamano[k]<mejor))
             {
                mejor=tamano[k];
                imejor=k;
             }

         for (j=1;j<=MAXFAM;j++)        // Para cada familia
         {
             if (enrango(animal, j))    // Es posible codificar en esta familia?
             {
                // Elegir mejor opcion para cambiar a esta familia usando las mejores
                // codificaciones para el animal anterior
                mejor=INT_MAX;

                // Considerar los costos de codificacin en cada
                // familia para el animal anterior
                for (k=1;k<=MAXFAM;k++)
                {
                    if (tabla[k][i-1]!=-1)      // Es valida esta familia?
                    {
                       if (k==j)                // Si no cambia fam no hay costo de cambio de fam
                          total=tabla[k][i-1]+tamano[k];
                       else
                          total=tabla[k][i-1]+tamano[k]+tamano[j];
                       if (total<mejor)
                       {
                          mejor=total;
                          nmejor=k;
                       }
                    }
                }
                tabla[j][i]=mejor; // Actualizar tabla con mejor opcion encontrada
                solucion[j][i]=(int)nmejor;
             }
             else       // Intentar hacer cambio por un solo animal
             {
                if (tabla[j][i-1]!=-1) // Es valido hacer el cambio en esta familia?
                {
                   tabla[j][i]=tabla[j][i-1]+tamano[j]+tamano[imejor];
                   solucion[j][i]=(int)16+imejor;
                }
                else
                   tabla[j][i]=-1;
             }
         }
     }
}

// Funcion recursiva que reconstruye la codificacion usada en la solucion
void sol (int pos, char fam)
{
     if (!pos)
        return;
     if (solucion[fam][pos]>16)
        sol (pos-1, fam);
     else
        sol (pos-1, solucion[fam][pos]);
     if (solucion[fam][pos]>16)
        fprintf (salida, "%d %d+\n", pos, solucion[fam][pos]-16);
     else
        if (solucion[fam][pos]!=fam)
           fprintf (salida, "%d %d\n", pos, fam);
}

// Funcion graba la respuesta en el archivo y cierra archivos abiertos
void finalizar()
{
     int i, j, mejor, nmejor;
     
     salida = fopen (ARCSAL, "wt");

     // Buscar la mejor solucion para n animales
     mejor = INT_MAX;

     for (i=1;i<=MAXFAM;i++)
         if ((mejor>tabla[i][n])&&(tabla[i][n]!=-1))
         {
            mejor=tabla[i][n];
            nmejor=i;
         }
     fprintf (salida, "%d\n", mejor);
     fclose (entrada);
     fclose (salida);
     exit(0);
}

int main()
{
    inicializar();
    procesar();
    finalizar();
}
