/*
  CIIC 2002
  Problema Planeta
  Solucin Recursiva
  Raul Duque
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <conio.h>

/* Declaraciones */

FILE *entrada, *salida;
char cadena[60];
char aux[50];
int sol[50];
int  contar, num, N;
// contar guarda el nmero de soluciones diferentes

// Este arreglo guarda la cantidad de dgitos necesaria para representar
// cada nmero en binario. Posteriormente sirve para revisar que no
// se tomen en cuenta ceros a la izquierda
/*                       0  1  2  3  4  5  6  7  8  9 */
const int cantdig[10] = {1, 1, 2, 2, 3, 3, 3, 3, 4, 4};


void inicializar()
{
     clrscr();
     entrada=fopen("planeta.ent","rt");
     fscanf (entrada, "%s", cadena);
     N=strlen(cadena);
     fclose (entrada);
     salida=fopen("planeta.sal","wt");
}

// Convierte una cadena binaria a un nmero decimal
char dec (char *cad)
{
     char i, r=0, d=1;

     for (i=strlen(cad)-1;i>=0;i--)
     {
         if (cad[i]=='1')
            r|=d;
         d<<=1;
     }
     return (r);
}

// Prueba los posibles dgitos que se formen a partir de una posicin en la
// cadena binaria dada. n indica la posicin de ese dgito dentro de la
// solucin actual
void procesar (char pos, char n)
{
     char i;
     char j;

     // Probar con las posibles subcadenas a partir de la posicin dada
     for (i=0;i<=3;i++)         // i+1 indica el nmero de dgitos que se
     {                          // copian de la cadena binaria

         if (pos+i==N) // Si llegamos al final de la cadena cortar el ciclo
            break;

         // Copiar i+1 digitos en aux
         memmove(aux, &cadena[pos], i+1);
         aux[i+1]='\x0';
         num=dec(aux);
         // Si este usa ms digitos (tiene ceros a la izquierda)
         // o da un nmero mayor a 9 no es una subcadena vlida
         if ((strlen(aux)>cantdig[num])||(num>9))
            continue;

         // Aqu se form un nmero vlido en la subcadena
         sol[n]=num;

         // Si ya se tom en cuenta toda la cadena binaria imprimir
         // la solucin almacenada
         if (pos+i==N-1)
         {
            contar++;
            for (j=0;j<=n;j++)
                fprintf (salida, "%d",sol[j]);
            fprintf (salida,"\n");
         }
         else
            // Sino, entonces procesar el resto de la cadena
            procesar (pos+i+1, n+1);
     }
}

void finalizar()
{
     // Imprimir el nmero de soluciones encontradas
     //fprintf (salida, "%d\n", contar);
     printf ("%d\n", contar);
     fclose (entrada);
}

main()
{
    inicializar();
    // Comenzar a procesar la cadena binaria en la primera posicin
    procesar(0, 0);
    finalizar();
}

